/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.function.polynomial.root.PolyRoot;
import dev.nm.analysis.function.polynomial.root.QuadraticRoot;
import dev.nm.misc.Constants;
import dev.nm.misc.datastructure.DimensionCheck;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CharacteristicPolynomial
implements Spectrum {
    private final Matrix if;
    private final Polynomial new;

    public String toString() {
        return this.new.toString();
    }

    public Polynomial getCharacteristicPolynomial() {
        switch (this.if.nRows()) {
            case 1: {
                return new Polynomial(1.0, -this.if.get(1, 1));
            }
            case 2: {
                return new Polynomial(1.0, -MatrixMeasure.tr(this.if), MatrixMeasure.det(this.if));
            }
            case 3: {
                return null;
            }
            case 4: {
                return null;
            }
        }
        return null;
    }

    public List<Number> getEigenvalues() {
        ArrayList<Number> a2 = new ArrayList<Number>();
        switch (this.if.nRows()) {
            case 1: {
                a2.add(new Double(this.if.get(1, 1)));
                break;
            }
            case 2: {
                QuadraticRoot a3 = new QuadraticRoot();
                double[] a4 = this.new.getCoefficients();
                double a5 = a4[1];
                double a6 = a4[2];
                double a7 = Math.min(Math.abs(a5), Math.abs(a6)) * Math.sqrt(2.0) * Constants.EPSILON * 10.0;
                List<Number> a8 = a3.solve(this.new, a7);
                a2.addAll(a8);
                break;
            }
            case 3: 
            case 4: {
                a2.addAll(new PolyRoot().solve(this.new));
                break;
            }
            default: {
                throw new IllegalArgumentException("by Abel-Ruffini theorem, a general polynomial of order n\u2008>\u20084 cannot be solved by a finite sequence of arithmetic operations and radicals");
            }
        }
        return a2;
    }

    public CharacteristicPolynomial(Matrix A2) {
        if (!DimensionCheck.isSquare(A2)) {
            throw new IllegalArgumentException("Eigenvalue decomposition applies only to square matrix");
        }
        this.if = A2;
        this.new = this.getCharacteristicPolynomial();
    }
}

